<!-- Jquery Library File -->
<script src="js/jquery-3.7.1.min.js"></script>
<!-- Bootstrap js file -->
<script src="js/bootstrap.min.js"></script>
<!-- Validator js file -->
<script src="js/validator.min.js"></script>
<!-- SlickNav js file -->
<script src="js/jquery.slicknav.js"></script>
<!-- Swiper js file -->
<script src="js/swiper-bundle.min.js"></script>
<!-- Counter js file -->
<script src="js/jquery.waypoints.min.js"></script>
<script src="js/jquery.counterup.min.js"></script>
<!-- Magnific js file -->
<script src="js/jquery.magnific-popup.min.js"></script>
<!-- SmoothScroll -->
<script src="js/SmoothScroll.js"></script>
<!-- Parallax js -->
<script src="js/parallaxie.js"></script>
<!-- MagicCursor js file -->
<script src="js/gsap.min.js"></script>
<script src="js/magiccursor.js"></script>
<!-- Text Effect js file -->
<script src="js/splitType.js"></script>
<script src="js/ScrollTrigger.min.js"></script>
<!-- Wow js file -->
<script src="js/wow.js"></script>
<!-- Main Custom js file -->
<script src="js/function.js"></script>

<!-- OWL Carousel -->
<script src="js/owl.carousel.min.js"></script>

<script>
$(document).ready(function() {

    // Número de slides
    let imgItems = $('.slider li').length;
    let imgPos = 1;

    // Agregando paginación
    for (let i = 0; i < imgItems; i++) {
        $('.pagination').append('<li><i class="fa fa-circle"></i></li>');
    }

    // Ocultamos todos los slides
    $('.slider li').hide();
    // Mostramos el primer slide
    $('.slider li:first').show();

    // Damos estilos al primer item de la paginación
    $('.pagination li:first').css({
        'color': '#cd6e2e'
    });

    // Ejecutamos todas las funciones
    $('.pagination li').on('click', pagination);
    $('.right i').on('click', nextSlider);
    $('.left i').on('click', prevSlider);

    // El slider se ejecuta automaticamente cada 5 segundos
    let sliderAuto = setInterval(function() {
        nextSlider();
    }, 4000);

    // Funciones
    function pagination() {
        // Posición de la paginación seleccionada
        let paginationPos = $(this).index() + 1;
        // Ocultamos todos los slides
        $('.slider li').hide();
        // Mostramos el slide seleccionado
        $(`.slider li:nth-child(${paginationPos})`).fadeIn(1000);
        // Dandole estilos a la paginación seleccionada
        $('.pagination li').css({
            'color': '#858585'
        })
        $(this).css({
            'color': '#cd6e2e'
        });
        imgPos = paginationPos;
    }

    function nextSlider() {
        imgPos >= imgItems ? imgPos = 1 : imgPos++;
        $('.pagination li').css({
            'color': '#858585'
        });
        $(`.pagination li:nth-child(${imgPos})`).css({
            'color': '#cd6e2e'
        });
        // Ocultamos todos los slide
        $('.slider li').hide();
        // Mostramos el slide seleccionado
        $(`.slider li:nth-child(${imgPos})`).fadeIn();
    }

    function prevSlider() {
        imgPos <= 1 ? imgPos = imgItems : imgPos--;
        $('.pagination li').css({
            'color': '#858585'
        });
        $(`.pagination li:nth-child(${imgPos})`).css({
            'color': '#cd6e2e'
        });
        // Ocultamos todos los slide
        $('.slider li').hide();
        // Mostramos el slide seleccionado
        $(`.slider li:nth-child(${imgPos})`).fadeIn(1000);
    }

    // Cuando le damos click a las flechas o a la paginación el slider deja de ser automatico
    $('.left i, .right i').on('click', function() {
        clearInterval(sliderAuto);
    });

    // Cuando presionamos la tecla de la derecha el slider avanza
    // Cuando presionamos la tecla de la izquierda el slider se devuelve
    $(document).on('keydown', function(e) {
        e.keyCode == 37 ? $('.left i').trigger('click') : '';
        e.keyCode == 39 ? $('.right i').trigger('click') : '';
    });

});
</script>


<script>
function calcularPoliza() {
    var monto = parseFloat(document.getElementById("monto").value);
    var porcentaje;
    // var poliza = "basico";
    var poliza = document.getElementById("poliza").value;
    porcentaje = calcularPorcentaje(monto, poliza);


    var costo = monto * porcentaje;

    // Formatear el costo con comas para separar los miles
    var costoFormateado = costo.toLocaleString('en-US', { maximumFractionDigits: 2 });

    document.getElementById("resultado").innerHTML = "El costo de la póliza es: $" + costoFormateado;
    // document.getElementById("resultado").innerHTML = "El costo de la póliza es: $" + costo.toFixed(2);
}

function calcularPorcentaje(monto, poliza) {

  var porcentajesPremium = [
        { monto: 15000, porcentaje: 0.53 }, // 53%
        { monto: 20000, porcentaje: 0.54 }, // 54%
        { monto: 25000, porcentaje: 0.55 }, // 55%
        { monto: 30000, porcentaje: 0.56 }, // 56%
        { monto: 35000, porcentaje: 0.57 }, // 57%
        { monto: 40000, porcentaje: 0.58 },  // 58%
        { monto: 45000, porcentaje: 0.59 },  // 59%
        { monto: 50000, porcentaje: 0.60 }  // 60%
    ];

    var porcentajesMega = [
        { monto: 15000, porcentaje: 0.55 }, // 54%
        { monto: 20000, porcentaje: 0.54 }, // 53%
        { monto: 25000, porcentaje: 0.53 }, // 52%
        { monto: 30000, porcentaje: 0.52 }, // 51%
        { monto: 35000, porcentaje: 0.51 }, // 50%
        { monto: 40000, porcentaje: 0.50 }, // 49%
        { monto: 45000, porcentaje: 0.49 },  // 48%
        { monto: 60000, porcentaje: 0.48 }  // 48%
    ];

    var porcentajesBasico = [
        { monto: 16000, porcentaje: 0.50 }, // 54%
        { monto: 21000, porcentaje: 0.49 }, // 49%
        { monto: 26000, porcentaje: 0.48 }, // 48%
        { monto: 31000, porcentaje: 0.47 }, // 47%
        { monto: 36000, porcentaje: 0.46 }, // 46%
        { monto: 41000, porcentaje: 0.45 },  // 45%
        { monto: 46000, porcentaje: 0.44 },  // 44%
        { monto: 51000, porcentaje: 0.43 }  // 43%
    ];

    

    var porcentajes;
    if (poliza == "mega") {
        porcentajes = porcentajesMega;
    } 
    else if (poliza == "basico") {
        porcentajes = porcentajesBasico;
    }
    else if (poliza == "premium") {
        porcentajes = porcentajesPremium;
    }
    else if (poliza == "emprendedor") {
        return 0.01;
    }
    for (var i = 0; i < porcentajes.length; i++) {
        if (monto < porcentajes[i].monto) {
            return porcentajes[i].porcentaje;
        }
    }

    if (poliza == "basico") {
         // Por defecto, si no coincide con ninguna tabla, devuelve 0.55 (55%)
        return 0.35;
    }
    else if (poliza == "mega") {
        return 0.47;
    }
    else if (poliza == "premium") {
        return 0.61;
    }

   
}
</script>

<!-- WhatsApp float -->
<script>
    (function($) {
  var wa_time_out, wa_time_in;
  $(document).ready(function() {
    $(".wa__btn_popup").on("click", function() {
      if ($(".wa__popup_chat_box").hasClass("wa__active")) {
        $(".wa__popup_chat_box").removeClass("wa__active");
        $(".wa__btn_popup").removeClass("wa__active");
        clearTimeout(wa_time_in);
        if ($(".wa__popup_chat_box").hasClass("wa__lauch")) {
          wa_time_out = setTimeout(function() {
            $(".wa__popup_chat_box").removeClass("wa__pending");
            $(".wa__popup_chat_box").removeClass("wa__lauch");
          }, 400);
        }
      } else {
        $(".wa__popup_chat_box").addClass("wa__pending");
        $(".wa__popup_chat_box").addClass("wa__active");
        $(".wa__btn_popup").addClass("wa__active");
        clearTimeout(wa_time_out);
        if (!$(".wa__popup_chat_box").hasClass("wa__lauch")) {
          wa_time_in = setTimeout(function() {
            $(".wa__popup_chat_box").addClass("wa__lauch");
          }, 100);
        }
      }
    });

    function setCookie(cname, cvalue, exdays) {
      var d = new Date();
      d.setTime(d.getTime() + exdays * 24 * 60 * 60 * 1000);
      var expires = "expires=" + d.toUTCString();
      document.cookie = cname + "=" + cvalue + ";" + expires + ";path=/";
    }

    function getCookie(cname) {
      var name = cname + "=";
      var ca = document.cookie.split(";");
      for (var i = 0; i < ca.length; i++) {
        var c = ca[i];
        while (c.charAt(0) == " ") {
          c = c.substring(1);
        }
        if (c.indexOf(name) == 0) {
          return c.substring(name.length, c.length);
        }
      }
      return "";
    }

    $("#nta-wa-gdpr").change(function() {
      if (this.checked) {
        setCookie("nta-wa-gdpr", "accept", 30);
        if (getCookie("nta-wa-gdpr") != "") {
          $('.nta-wa-gdpr').hide(500);
          $('.wa__popup_content_item').each(function(){
            $(this).removeClass('pointer-disable');
            $('.wa__popup_content_list').off('click');
          })
        }
      }
    });

    if (getCookie("nta-wa-gdpr") != "") {
      $('.wa__popup_content_list').off('click');
    } else{
      $('.wa__popup_content_list').click(function(){
        $('.nta-wa-gdpr').delay(500).css({"background" : "red", "color" : "#fff"});
      });
    }
  });
  })(jQuery);
</script>

<!-- Carousel Index -->
<script>
  $('.owl-carousel').owlCarousel({
    loop:true,
    margin:5,
    nav:false,
    autoplay:true,
    autoplayTimeout:10000,
    responsive:{
        0:{
            items:1
        },
        600:{
            items:1
        },
        1000:{
            items:1
        }
    }
})
</script>