<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Calculadora de Póliza de Arrendamiento</title>
<style>
    body {
        font-family: Arial, sans-serif;
    }
    .container {
        max-width: 400px;
        margin: 0 auto;
        padding: 20px;
        border: 1px solid #ccc;
        border-radius: 5px;
    }
    input[type="number"], input[type="text"] {
        width: 100%;
        padding: 10px;
        margin: 5px 0;
        border: 1px solid #ccc;
        border-radius: 3px;
    }
    button {
        width: 100%;
        padding: 10px;
        background-color: #007bff;
        color: #fff;
        border: none;
        border-radius: 3px;
        cursor: pointer;
    }
    button:hover {
        background-color: #0056b3;
    }
</style>
</head>
<body>

<div class="container">
    <h2>Calculadora de Póliza de Arrendamiento</h2>
    <label for="monto">Monto:</label>
    <input type="number" id="monto" placeholder="Ingrese el monto" required>
    <button onclick="calcularPoliza()">Calcular</button>
    <div id="resultado"></div>
</div>

<script>
function calcularPoliza() {
    var monto = parseFloat(document.getElementById("monto").value);
    var porcentaje;
    // var poliza = "basico";
    var poliza = document.getElementById("poliza").value;

    porcentaje = calcularPorcentaje(monto, poliza);


    var costo = monto * porcentaje;
    document.getElementById("resultado").innerHTML = "El costo de la póliza es: $" + costo.toFixed(2);
}

function calcularPorcentaje(monto, poliza) {
    var porcentajesMega = [
        { monto: 15000, porcentaje: 0.45 }, // 54%
        { monto: 20000, porcentaje: 0.46 }, // 53%
        { monto: 25000, porcentaje: 0.47 }, // 52%
        { monto: 30000, porcentaje: 0.48 }, // 51%
        { monto: 35000, porcentaje: 0.49 }, // 50%
        { monto: 40000, porcentaje: 0.50 }, // 49%
        { monto: 45000, porcentaje: 0.51 },  // 48%
        { monto: 50000, porcentaje: 0.52 }  // 48%
    ];

    var porcentajesBasico = [
        { monto: 16000, porcentaje: 0.50 }, // 54%
        { monto: 21000, porcentaje: 0.51 }, // 53%
        { monto: 26000, porcentaje: 0.52 }, // 52%
        { monto: 31000, porcentaje: 0.53 }, // 50%
        { monto: 36000, porcentaje: 0.54 }, // 49%
        { monto: 41000, porcentaje: 0.55 },  // 48%
        { monto: 46000, porcentaje: 0.56 },  // 48%
        { monto: 51000, porcentaje: 0.57 }  // 48%
    ];
    var porcentajes;
    if (poliza == "mega") {
        porcentajes = porcentajesMega;
    } else if (poliza == "basico") {
        porcentajes = porcentajesBasico;
    }
    for (var i = 0; i < porcentajes.length; i++) {
        if (monto < porcentajes[i].monto) {
            return porcentajes[i].porcentaje;
        }
    }

    if (poliza == "mega") {
         // Por defecto, si no coincide con ninguna tabla, devuelve 0.55 (55%)
        return 0.53;
    }
    else if (poliza == "basico") {
        return 0.65;
    }

   
}
</script>

</body>
</html>
